// |jit-test| skip-if: !getBuildConfiguration("explicit-resource-management"); --enable-explicit-resource-management

load(libdir + "asserts.js");

{
  const g = newGlobal({ newCompartment: true });
  const d = g.eval(`
    globalThis.disposed = [];
    const d = new AsyncDisposableStack();
    d.use({ [Symbol.asyncDispose]: () => globalThis.disposed.push(1) });
    d;
  `);
  AsyncDisposableStack.prototype.disposeAsync.call(d);
  drainJobQueue();
  assertEq(d.disposed, true);
  assertArrayEq(g.eval("globalThis.disposed"), [1]);
}

{
  const g = newGlobal({ newCompartment: true });
  const d = g.eval(`
    globalThis.disposed = [];
    const d = new AsyncDisposableStack();
    d.use({ [Symbol.asyncDispose]: () => globalThis.disposed.push(1) });
    d;
  `);
  nukeAllCCWs();
  assertThrowsInstanceOfAsync(() => AsyncDisposableStack.prototype.disposeAsync.call(d), TypeError);
}
